/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.filteradapter;

import com.webcodepro.applecommander.ui.swt.FileViewerWindow;
import com.webcodepro.applecommander.ui.swt.filteradapter.FilterAdapter;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.StyledTextAdapter;
import com.webcodepro.applecommander.util.BusinessBASICToken;
import com.webcodepro.applecommander.util.BusinessBASICTokenizer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class BusinessBASICFilterAdapter
extends FilterAdapter {
    private StyledText styledText;

    public BusinessBASICFilterAdapter(FileViewerWindow window, String text, String toolTipText, Image image) {
        super(window, text, toolTipText, image);
    }

    @Override
    public void display() {
        if (this.styledText == null) {
            this.createStyledText();
        }
        Point size = this.styledText.computeSize(-1, -1, true);
        this.getComposite().setContent(this.styledText);
        this.getComposite().setExpandHorizontal(true);
        this.getComposite().setExpandVertical(true);
        this.getComposite().setMinWidth(size.x);
        this.getComposite().setMinHeight(size.y);
        this.getComposite().getContent().addListener(2, this.getToolbarCommandHandler());
        this.setContentTypeAdapter(new StyledTextAdapter(this.styledText, this.getFileEntry().getFilename()));
    }

    @Override
    public void dispose() {
        this.styledText.dispose();
    }

    protected void createStyledText() {
        this.styledText = new StyledText(this.getComposite(), 0);
        this.styledText.setForeground(this.getBlackColor());
        this.styledText.setFont(this.getCourierFont());
        this.styledText.setEditable(false);
        BusinessBASICTokenizer tokenizer = new BusinessBASICTokenizer(this.getFileEntry());
        boolean firstLine = true;
        boolean firstData = true;
        int nestLevels = 0;
        while (tokenizer.hasMoreTokens()) {
            StyleRange styleRange;
            int caretOffset;
            BusinessBASICToken token = tokenizer.getNextToken();
            if (token == null) continue;
            if (token.isLineNumber()) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    this.styledText.append("\n");
                }
                firstData = true;
                this.styledText.append(Integer.toString(token.getLineNumber()));
                this.styledText.append("   ");
                if (nestLevels <= 0) continue;
                for (int i = 0; i < nestLevels; ++i) {
                    this.styledText.append("  ");
                }
                continue;
            }
            if (token.isCommandSeparator() || token.isExpressionSeparator()) {
                this.styledText.append(token.getStringValue());
                firstData = true;
                continue;
            }
            if (token.isEndOfCommand()) {
                this.styledText.append("\n");
                firstData = false;
                continue;
            }
            if (token.isString()) {
                if (!firstData) {
                    this.styledText.append(" ");
                }
                caretOffset = this.styledText.getCharCount();
                this.styledText.append(token.getStringValue().trim());
                styleRange = new StyleRange();
                styleRange.start = caretOffset;
                styleRange.length = token.getStringValue().trim().length();
                styleRange.foreground = this.getGreenColor();
                this.styledText.setStyleRange(styleRange);
                firstData = false;
                continue;
            }
            if (!token.isToken()) continue;
            if (!firstData) {
                this.styledText.append(" ");
            }
            caretOffset = this.styledText.getCharCount();
            this.styledText.append(token.getTokenString());
            styleRange = new StyleRange();
            styleRange.start = caretOffset;
            styleRange.length = token.getTokenString().length();
            styleRange.foreground = this.getBlueColor();
            this.styledText.setStyleRange(styleRange);
            firstData = false;
            if (token.isIndenter()) {
                ++nestLevels;
                continue;
            }
            if (!token.isOutdenter()) continue;
            --nestLevels;
        }
    }
}

